<?php

namespace Symfony\Config\Security\ProviderConfig;

use Symfony\Component\Config\Loader\ParamConfigurator;
use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;

/**
 * This class is automatically generated to help in creating a config.
 */
class EntityConfig 
{
    private $class;
    private $property;
    private $managerName;
    private $_usedProperties = [];

    /**
     * The full entity class name of your user class.
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function class($value): static
    {
        $this->_usedProperties['class'] = true;
        $this->class = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function property($value): static
    {
        $this->_usedProperties['property'] = true;
        $this->property = $value;

        return $this;
    }

    /**
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function managerName($value): static
    {
        $this->_usedProperties['managerName'] = true;
        $this->managerName = $value;

        return $this;
    }

    public function __construct(array $config = [])
    {
        if (array_key_exists('class', $config)) {
            $this->_usedProperties['class'] = true;
            $this->class = $config['class'];
            unset($config['class']);
        }

        if (array_key_exists('property', $config)) {
            $this->_usedProperties['property'] = true;
            $this->property = $config['property'];
            unset($config['property']);
        }

        if (array_key_exists('manager_name', $config)) {
            $this->_usedProperties['managerName'] = true;
            $this->managerName = $config['manager_name'];
            unset($config['manager_name']);
        }

        if ($config) {
            throw new InvalidConfigurationException(sprintf('The following keys are not supported by "%s": ', __CLASS__).implode(', ', array_keys($config)));
        }
    }

    public function toArray(): array
    {
        $output = [];
        if (isset($this->_usedProperties['class'])) {
            $output['class'] = $this->class;
        }
        if (isset($this->_usedProperties['property'])) {
            $output['property'] = $this->property;
        }
        if (isset($this->_usedProperties['managerName'])) {
            $output['manager_name'] = $this->managerName;
        }

        return $output;
    }

}
